//*************************************************************************************************
//
//	Description:
//		Shaders used for render profiling
//		
//		
//
//	<P> Copyright (c) 2006 Blimey! Games Ltd. All rights reserved.
//
//	Author: 
//		Matt Hobbs
//
//	History:
//
//	<TABLE>
//		\Author         Date        Version       Description
//		--------        -----       --------      ------------
//		Matt             08/12/2006  Created
//		TMann			 09/01/2007	 Added PS3/GL
//
//	<TABLE>
//
//*************************************************************************************************

#if defined(_XBOX) && !defined(_TOOLS_COMPILATION_)
#include "D:\Render\Shaders\stddefs.fxh"
#else
#include "stddefs.fxh"
#endif

#if defined(_PS3_)
#define _MINFILTER	LinearMipMapLinear
#else
#define _MINFILTER	Linear
#define SET_NO_ANISOTROPY MaxAnisotropy = 1;
#endif

//
// Transforms
//
SHARE_PARAM float4x4 worldviewproj : WorldViewProjection
<
	string UIWidget = "None";
	bool appEdit = false;
	bool export = false;
	bool dynamic = true;
>;



//-----------------------------------------------------------------------
//
// Profiling shader
//

struct PRM_VSINPUT
{
	float3 position : POSITION;												
	float2 profileData : TEXCOORD0;
};

struct PRM_VSOUTPUT
{
	float4 position		: POSITION;												
	float4 colour		: COLOR0;
};

PRM_VSOUTPUT PRM_vertexShader( PRM_VSINPUT _input )
{
	PRM_VSOUTPUT _output = ( PRM_VSOUTPUT )0;
	
	// get vertex position in clip space
	_output.position = mul( float4( _input.position, 1.0f ), worldviewproj );

	// colour track poly based on profile data
	// TODO: do we want a < here?
	if(_input.profileData.x <= 0.0)
	{
		// the data here is invalid, set to white (i.e. no data here)
		_output.colour.x = 1.0;
		_output.colour.y = 1.0;
		_output.colour.z = 1.0;
		_output.colour.w = 1.0;	
	}
	else if(_input.profileData.x <= 0.6)
	{
		_output.colour.x = 0.0;
		_output.colour.y = 0.0;
		_output.colour.z = 1.0;
		_output.colour.w = 1.0;	
	}
	else if(_input.profileData.x <= 0.8)
	{
		_output.colour.x = 0.0;
		_output.colour.y = 0.85;
		_output.colour.z = 1.0;
		_output.colour.w = 1.0;	
	}
	else if(_input.profileData.x <= 1.2)
	{
		_output.colour.x = 0.0;
		_output.colour.y = 1.0;
		_output.colour.z = 0.0;
		_output.colour.w = 1.0;	
	}
	else if(_input.profileData.x <= 1.4)
	{
		_output.colour.x = 1.0;
		_output.colour.y = 0.5;
		_output.colour.z = 0.5;
		_output.colour.w = 1.0;	
	}
	else
	{
		_output.colour.x = 1.0;
		_output.colour.y = 0.0;
		_output.colour.z = 0.0;
		_output.colour.w = 1.0;	
	}
	
	return _output;
}

PRM_VSOUTPUT PRM_vertexShaderRedToGreen( PRM_VSINPUT _input )
{
	PRM_VSOUTPUT _output = ( PRM_VSOUTPUT )0;
	
	// get vertex position in clip space
	_output.position = mul( float4( _input.position, 1.0f ), worldviewproj );

	// colour track poly based on profile data
	if(_input.profileData.x < 0.0)
	{
		// the data here is invalid, set to white (i.e. no data here)
		_output.colour.x = 1.0;
		_output.colour.y = 1.0;
		_output.colour.z = 1.0;
		_output.colour.w = 1.0;	
	}
	else 
	{
		// 0.0 = green -> 1.0 = red
		_output.colour.x = _input.profileData.x;
		_output.colour.y = 1.0 - _input.profileData.x;
		_output.colour.z = 0.0;
		_output.colour.w = 1.0;	
	}
	
	return _output;
}

struct PRM_PSINPUT
{
	float4 colour					: COLOR0;														
};

struct PRM_PSOUTPUT
{
	COLOUR_OUTPUT_TYPE colour					: COLOR0;
};

PRM_PSOUTPUT PRM_fragmentShader( PRM_PSINPUT _input )
{
	PRM_PSOUTPUT _output;	

	// pass thru
	_output.colour = _input.colour;
	
	return _output;
}

technique PolyRenderMetrics
<
	bool preservesGlobalState = true;
	string normalBehaviour		= "ERMB_RENDER";
	string normalTechnique		= "PolyRenderMetrics";
	int    normalDeferredID		= 0;
	string zprimeBehaviour		= "ERMB_DONT_RENDER";
	string zprimeDOFBehaviour	= "ERMB_DONT_RENDER";
	string shadowGenBehaviour = "ERMB_DONT_RENDER";
	string lowDetailBehaviour	= "ERMB_DONT_RENDER";
>
{
	pass Pass0
	{
#if defined (_PS3_)
		VertexShader = compile sce_vp_rsx PRM_vertexShaderRedToGreen();
		PixelShader = compile sce_fp_rsx PRM_fragmentShader();
#else		
		VertexShader = compile vs_3_0 PRM_vertexShaderRedToGreen();
		PixelShader = compile ps_3_0 PRM_fragmentShader();
#endif		
	}
}







//-----------------------------------------------------------------------
//
// Chunk displaying shader
//
//
//
//
//
//

struct CD_VSINPUT
{
	float3 position : POSITION;												
	float2 primColour : TEXCOORD0;
};

struct CD_VSOUTPUT
{
	float4 position		: POSITION;												
	float4 colour		: COLOR0;												
};

CD_VSOUTPUT CD_vertexShader( CD_VSINPUT _input )
{
	CD_VSOUTPUT _output = ( CD_VSOUTPUT )0;
	
	// get vertex position in clip space
	_output.position = mul( float4( _input.position, 1.0f ), worldviewproj );

	// colour poly based on colour for this MeshPrimitive
	_output.colour.x = _input.primColour.x;
	_output.colour.y = _input.primColour.y;
	_output.colour.z = 1.0 - _input.primColour.x;
	_output.colour.w = 1.0;

	return _output;
}

struct CD_PSINPUT
{
	float4 colour					: COLOR0;														
};

struct CD_PSOUTPUT
{
	COLOUR_OUTPUT_TYPE colour					: COLOR0;
};

CD_PSOUTPUT CD_fragmentShader( CD_PSINPUT _input )
{
	CD_PSOUTPUT _output;	

	// pass thru
	_output.colour = _input.colour;
		
	return _output;
}

technique ChunkDisplayer
<
	bool preservesGlobalState = true;
	string normalBehaviour		= "ERMB_RENDER";
	string normalTechnique		= "ChunkDisplayer";
	int    normalDeferredID		= 0;
	string zprimeBehaviour		= "ERMB_DONT_RENDER";
	string zprimeDOFBehaviour	= "ERMB_DONT_RENDER";
	string shadowGenBehaviour = "ERMB_DONT_RENDER";
	string lowDetailBehaviour	= "ERMB_DONT_RENDER";
>
{
	pass Pass0
	{
#if defined (_PS3_)
		VertexShader = compile sce_vp_rsx CD_vertexShader();
		PixelShader = compile sce_fp_rsx CD_fragmentShader();
#else		
		VertexShader = compile vs_3_0 CD_vertexShader();
		PixelShader = compile ps_3_0 CD_fragmentShader();
#endif
	}
}



